package org.msh.tb.bd.dashboard.summaryrep.parser;

import org.msh.tb.bd.Quarter;
import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;
import org.msh.tb.bd.dashboard.summaryrep.data.IndicatorRateData;
import org.msh.tb.bd.dashboard.summaryrep.data.SummaryIndicatorData;
import org.msh.tb.entities.enums.CaseClassification;
import org.msh.utils.date.DateUtils;
import org.msh.utils.date.Period;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;

/**
 * Created by mauri on 23/05/2017.
 * Parses information returned from IndicatorQuery to a SummaryIndicatorData object
 */
public class Indicator07Parser implements IndicatorParser {

    /**
     * The indicator code like 'indicator01' used by UI to generate some components
     */
    private String indicatorCode;

    public Indicator07Parser(String indicatorCode) {
        this.indicatorCode = indicatorCode;
    }

    @Override
    public SummaryIndicatorData parse(List<Object[]> result, String locationDesc) {
        Quarter quarter = Quarter.getCurrentQuarter().getPreviousQuarter();

        SummaryIndicatorData data = new SummaryIndicatorData(locationDesc, quarter.getQuarter().getKey() + ".2", "" + quarter.getYear(), indicatorCode);

        // get TB result
        for (Object[] o : result) {
            CaseClassification cla = (CaseClassification) o[0];
            if (CaseClassification.TB.equals(cla)) {
                Integer max = (Integer)o[1];
                Double avg = (Double)o[2];

                data.addIndicatorRate(max.floatValue(), null, "dashboard.indicator07.TB.max");
                data.addIndicatorRate(towDecimalPlaces(avg.floatValue()), null, "dashboard.indicator07.TB.avg");

                break;
            }
        }

        if (data.getIndicatorRates() == null || data.getIndicatorRates().size() < 2) {
            data.addIndicatorRate(null, "N/A", "dashboard.indicator07.TB.max");
            data.addIndicatorRate(null, "N/A", "dashboard.indicator07.TB.avg");
        }

        // get DRTB result
        for (Object[] o : result) {
            CaseClassification cla = (CaseClassification) o[0];
            if (CaseClassification.DRTB.equals(cla)) {
                Integer max = (Integer)o[1];
                Double avg = (Double)o[2];

                data.addIndicatorRate(max.floatValue(), null, "dashboard.indicator07.DRTB.max");
                data.addIndicatorRate(towDecimalPlaces(avg.floatValue()), null, "dashboard.indicator07.DRTB.avg");

                break;
            }
        }

        if (data.getIndicatorRates().size() < 4) {
            data.addIndicatorRate(null, "N/A", "dashboard.indicator07.DRTB.max");
            data.addIndicatorRate(null, "N/A", "dashboard.indicator07.DRTB.avg");
        }

        return data;
    }

    @Override
    public Period getPeriod() {
        return DashboardIndicatorUtils.getLastQuarterPeriod();
    }

    @Override
    public SummaryIndicatorData parse(List<Object[]> result, String locationDesc, SummaryIndicatorData nationalResult) {
        SummaryIndicatorData data = parse(result, locationDesc);

        for (IndicatorRateData rateData : data.getIndicatorRates()) {
            for (IndicatorRateData natRateData : nationalResult.getIndicatorRates()){

                if (natRateData.getRateDescMsg() != null && rateData.getRateDescMsg() != null &&
                        natRateData.getRateDescMsg().equals(rateData.getRateDescMsg())) {
                    rateData.setNationalRate(natRateData.getRate());
                    break;
                }
            }
        }

        return data;
    }

    private Float towDecimalPlaces(Float num){
        BigDecimal bd = new BigDecimal(num).setScale(2, RoundingMode.HALF_EVEN);
        return new Float(bd.floatValue());
    }

    public String getIndicatorCode() {
        return indicatorCode;
    }

    public void setIndicatorCode(String indicatorCode) {
        this.indicatorCode = indicatorCode;
    }
}
